public class Racional {
    //------------------------------------------------------------
    //---- Atributos ---------------------------------------------
    private int numerador;
    private int denominador;

    //------------------------------------------------------------
    //---- Constructor -------------------------------------------
    /**
     * Requiere d >0
     */
    public Racional (int n, int d) { 
        // Requiere den > 0
        if(n!=0){
            int mcd = mcd(n, d);
            numerador = n / mcd;
            denominador = d / mcd;
        }
        else{
            numerador = 0 ;
            denominador = 1;
        }
        
    }
    

    //------------------------------------------------------------
    //---- Comandos ----------------------------------------------
    public void establecerNum (int n) {
        if(n!=0){
            int mcd = mcd(n, denominador);
            numerador = n / mcd;
            denominador = denominador / mcd;
        }
        else{
            numerador = 0 ;
            denominador = 1;
        }
    }

    /**
     * Asegura d>0
     * Si d es mayor a 0 modifica el valor del atributo den y retorna true, 
     * en caso contrario retorna false.
     */
    public boolean establecerDen (int d) {
        
        if(d>0){
            if(numerador!=0){
                int mcd = mcd(numerador, d);
                numerador = numerador / mcd;
                denominador = d / mcd;
            }
            else{
                numerador = 0 ;
                denominador = 1;
            }
            return true;
        }
        else
            return false;
        
    }
    
    /**
     * Requiere rac ligada 
     */
    public void copy(Racional rac) {
        numerador = rac.obtenerNum();
        denominador = rac.obtenerDen();
    }
    
    //------------------------------------------------------------    
    //---- Consultas ---------------------------------------------
    public int obtenerNum() {
        return numerador;
    }

    public int obtenerDen() {
        return denominador;
    }

    /**
     * Requiere rac ligada 
     */
    public boolean equals(Racional rac) {
    
        return numerador == rac.obtenerNum()
            && denominador == rac.obtenerDen();
    }
    
    public Racional clone() {
        return new Racional(numerador, denominador);
    }
    
    public String toString() {
        if ((denominador == 1) || (numerador == 0)) {
            return numerador + "";
        } else {
            return numerador + "/" + denominador;
        }
    }
    
    /**
     * Requiere rac ligada 
     */
    public Racional suma(Racional rac) {
        int n,d;
        n = numerador * rac.obtenerDen() + rac.obtenerNum() * denominador;
        d = denominador * rac.obtenerDen();
        return simplificar(new Racional(n, d));
    }
    
    /**
     * Requiere rac ligada 
     */
    public Racional resta(Racional rac) {
        int n,d;
        n = numerador * rac.obtenerDen() - rac.obtenerNum() * denominador;
        d = denominador * rac.obtenerDen();
        return simplificar(new Racional(n, d));
    }
    
    /**
     * Requiere rac ligada 
     */
    public Racional producto(Racional rac) {
        int n = numerador * rac.obtenerNum();
        int d = rac.obtenerDen() * denominador;
        return simplificar(new Racional(n, d));
    }
    
    /**
     * Requiere rac ligada 
     */
    public Racional cociente(Racional rac) {
        int n, d;
        n = numerador * rac.obtenerDen();
        d = denominador * rac.obtenerNum();

        /**
         * Como el numerador es quien mantiene el signo del racional, en caso de que
         * sea negativo, ese signo debe ser pasado al numerador del racional a generar.
         */
        if (rac.obtenerNum() < 0) {
            n = n * -1;
            d = d * -1;
        } 
        else {
        /**
        * En caso de que el numerador sea 0, como la división por 0 no está definida,
        * se generará un racional especial determinado por numerador 0 y denominador 1.
        */
            if(rac.obtenerNum() == 0) {
                n = 0;
                d = 1;
            }
        }
        return simplificar(new Racional(n,d));
    }
    
    /**
     * Método auxiliar
     * Cómputo del Máximo Común Divisor según el algoritmo de Euclides. Asume x e y != 0
     */
    private int mcd( int x, int y ) {
        int a, b;
        a = Math.abs(x);
        b = Math.abs(y);
        while( a != b ) {
            if( a < b ) {
                b = b - a;
            } else {
                a = a - b;
            }
        }
        return a;
    }
    
    private Racional simplificar(Racional r) {
        int n, d, mcd;
        n = r.obtenerNum();
        d = r.obtenerDen();
        if (n != 0) {
            mcd = mcd(n, d);
            n = n / mcd;
            d = d / mcd;
        }
        return new Racional(n,d);
    }
}