import IPOO.*;
import java.util.*;

public class TesterRacional
{
    public static void main (String args[])
    {
        System.out.print("Ingrese el modo de testeo (m)anual / valores (f)ijos: ");
        char modo = ES.leerChar();
        while ((modo != 'm') && (modo != 'f')) {
            // Este ciclo asegura que solo se elegira una opcion valida
            System.out.print("Ingrese el modo de testeo (m)anual / valores (f)ijos: ");
            modo = ES.leerChar();
        }

        System.out.println("------------------------------------------");
        
        Racional rac1, rac2, rac3;
        
        // Se obtienen los valores de testeo segun el modo elegido
        if (modo == 'f')  {
            // Modo de testeo con valores fijos
            System.out.println("Se utilizaran los valores de prueba 1/2 y 3/6");
            System.out.println("Que deberian almacenarse y mostrarse en forma canonica");


            rac1 = new Racional(1,2);
            System.out.println("RAC1: " + rac1.toString());
            rac2 = new Racional(3,6);
            System.out.println("RAC2: " + rac2.toString());
        }
         else {
            // Modo de testeo con valores ingresados manualmente
            int num1, num2, den1, den2;
            
            System.out.println("Se solicitarán dos racionales");
            System.out.print("Ingrese el numerador del primer racional: ");            
            num1 = ES.leerEntero();
            System.out.print("Ingrese el denominador del primer racional (debe ser mayor a cero)");
            den1 = ES.leerEntero();
            while (den1 <= 0) {
                System.out.print("Error, el denominador debe ser mayor a de cero, vuelva a ingresar: ");
                den1 = ES.leerEntero();
            }
            
            System.out.print("Ingrese el numerador del segundo racional: ");            
            num2 = ES.leerEntero();
            System.out.print("Ingrese el denominador del segundo racional (debe ser mayor a cero)");
            den2 = ES.leerEntero();
            while (den2 <= 0) {
                System.out.print("Error, el denominador debe ser mayor a cero, vuelva a ingresar: ");
                den2 = ES.leerEntero();
            }
            
            rac1 = new Racional(num1, den1);
            rac2 = new Racional(num2, den2);
            
            System.out.println("------------------------------------------");
            System.out.println("RAC1: " + rac1.toString());
            System.out.println("RAC2: " + rac2.toString());
            
            
        }
        
        System.out.println("------------------------------------------");
        System.out.println("-- Test de operaciones aritméticas -------");
        System.out.println("------------------------------------------");
        System.out.println("TEST DE suma");
        
        rac3 = rac1.suma(rac2);
        System.out.println(rac1.toString() + " + " + rac2.toString() + " = " + rac3.toString());

        System.out.println("------------------------------------------");
        System.out.println("TEST DE resta");
        
        rac3 = rac1.resta(rac2);
        System.out.println(rac1.toString() + " - " + rac2.toString() + " = " + rac3.toString());
        rac3 = rac2.resta(rac1);
        System.out.println(rac2.toString() + " - " + rac1.toString() + " = " + rac3.toString());
        
        System.out.println("------------------------------------------");
        System.out.println("TEST DE producto");
        
        rac3 = rac1.producto(rac2);
        System.out.println(rac1.toString() + " * " + rac2.toString() + " = " + rac3.toString());
        rac3 = rac2.producto(rac1);
        System.out.println(rac2.toString() + " * " + rac1.toString() + " = " + rac3.toString());

        System.out.println("------------------------------------------");
        System.out.println("TEST DE cociente");
        System.out.println();

        System.out.println("(En caso de que el numerador del segundo racional sea 0, ");
        System.out.println("como la división por 0 no está definida, se generará "); 
        System.out.println("un racional especial determinado por numerador 0 y denominador 1)");
        
        rac3 = rac1.cociente(rac2);
        System.out.println(rac1.toString() + " / " + rac2.toString() + " = " + rac3.toString());
        rac3 = rac2.cociente(rac1);
        System.out.println(rac2.toString() + " / " + rac1.toString() + " = " + rac3.toString());

        System.out.println();
        System.out.println("------------------------------------------");
        System.out.println("-- Test de utilidades --------------------");
        System.out.println("------------------------------------------");
        System.out.println();
        
        System.out.println("TEST DE equals");
        
        System.out.println("RAC1: " + rac1.toString());
        System.out.println("RAC2: " + rac2.toString());
        System.out.println("RAC3: " + rac3.toString());
        
        System.out.println("RAC1 equals RAC2 => " +  rac1.equals(rac2));
        System.out.println("RAC1 equals RAC3 => " +  rac1.equals(rac3));
        System.out.println("RAC2 equals RAC3 => " +  rac2.equals(rac3));
        
        System.out.println("------------------------------------------");
        System.out.println("TEST DE clone");
        
        System.out.println("RAC1: " + rac1.toString());
        System.out.println("RAC2: " + rac2.toString());
        System.out.println("RAC3: " + rac3.toString());
        
        System.out.println("RAC3 = RAC1.clone()");
        rac3 = rac1.clone();
        System.out.println("RAC1 = RAC2.clone()");
        rac1 = rac2.clone();
        
        System.out.println("RAC1: " + rac1.toString());
        System.out.println("RAC2: " + rac2.toString());
        System.out.println("RAC3: " + rac3.toString());
        
        System.out.println("------------------------------------------");
        System.out.println("TEST DE copy");
        System.out.println("RAC1: " + rac1.toString());
        System.out.println("RAC2: " + rac2.toString());
        System.out.println("RAC3: " + rac3.toString());
        
        System.out.println("RAC1.copy(RAC3)");
        rac1.copy(rac3);
        System.out.println("RAC3.copy(RAC2)");
        rac3.copy(rac2);
        
        System.out.println("RAC1: " + rac1.toString());
        System.out.println("RAC2: " + rac2.toString());
        System.out.println("RAC3: " + rac3.toString());
    }
}
