package Final;

import TDAGrafo.Digrafos.GraphD;
import TDAGrafo.Exception.InvalidEdgeException;
import TDAGrafo.Exception.InvalidVertexException;
import TDAGrafo.VerticesDecorados.*;
import TDALista.PositionList;
import TDAMap.InvalidKeyException;
import TDAMap.Map;
import TDAMap.MapSeparateChaining;

public class Final1<V,E> {
    private final Object VISITADO = new Object();
    private final Object NO_VISITADO = new Object() ;
    private final Object ESTADO = new Object();


    /**
     * Recibe un Digrafo g y el rotulo de un vertice v, examina si existe un vertice en el grafo con
     * el rotulo recibido. En caso de existir, realiza un recorrido DFS partiendo del mismo y almacena en
     * un mapeo a los vertices encontrados, junto con un Par(X,Y) donde X representa los arcos emergentes
     * al vertice e Y los incidentes.
     * Para el recorrido DFS utiliza Vertices decorados.
     * @param g Digrafo.
     * @param r Rotulo.
     * @return mapeo con cada vertice encontrado en el recorrido junto a su Par(X,Y).
     * @throws Error en el caso de que el rotulo r no se encuentre en el Digrafo g.
     */
    public Map<Vertex<V>, Par> mapConArcos(GraphD<V,E> g, V r) throws Error{
        Map<Vertex<V>, Par> map = new MapSeparateChaining<>();
        boolean estado = false;
        try {
            for(Vertex<V> vertice : g.vertices()){
                if(vertice.element() == r) {
                    estado = true;
                    break;
                }
            }
            if (estado) {
                for(Vertex<V> vertice : g.vertices()){
                    vertice.put(ESTADO, NO_VISITADO);
                }
                for(Vertex<V> vertice : g.vertices()){
                    if(vertice.get(ESTADO) == NO_VISITADO){
                        if(vertice.element() == r) {
                            mapConArcosDFS(g, vertice, map);
                        }
                    }
                }
            }
            else {
                throw new Error(r+" no se encuentra en el Digrafo recibido.");
            }


        } catch (InvalidKeyException e) {
            throw new RuntimeException(e);
        }
        return map;
    }

    private void mapConArcosDFS(GraphD<V,E> g, Vertex<V> v, Map<Vertex<V>, Par> m) {
        try {
            PositionList<Edge<E>> emergentes = (PositionList<Edge<E>>) g.incidentEdges(v);
            PositionList<Edge<E>> incidentes = (PositionList<Edge<E>>) g.succesorEdges(v);
            m.put(v, new Par(emergentes.size(), incidentes.size()));
            v.put(ESTADO, VISITADO);
            for(Edge<E> e : g.incidentEdges(v)){
                Vertex<V> vertice = g.opposite(v, e);
                if(vertice.get(ESTADO) == NO_VISITADO){
                    mapConArcosDFS(g, vertice, m);
                }
            }
        } catch (InvalidVertexException | InvalidKeyException | InvalidEdgeException e) {
            System.out.println(e.getMessage());
        }
    }
}
